unit ULinhas;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ZedGraph, System.Globalization;

type
  TFrmLinhas = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ZedGraphControl1: ZedGraph.ZedGraphControl;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrmLinhas_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrmLinhas))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmLinhas.InitializeComponent;
begin
  Self.ZedGraphControl1 := ZedGraph.ZedGraphControl.Create;
  Self.SuspendLayout;
  // 
  // ZedGraphControl1
  // 
  Self.ZedGraphControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ZedGraphControl1.CultureInfo := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.ZedGraphControl1.IsAutoScrollRange := False;
  Self.ZedGraphControl1.IsEnableHPan := True;
  Self.ZedGraphControl1.IsEnableVPan := True;
  Self.ZedGraphControl1.IsEnableZoom := True;
  Self.ZedGraphControl1.IsScrollY2 := False;
  Self.ZedGraphControl1.IsShowContextMenu := True;
  Self.ZedGraphControl1.IsShowHScrollBar := False;
  Self.ZedGraphControl1.IsShowPointValues := False;
  Self.ZedGraphControl1.IsShowVScrollBar := False;
  Self.ZedGraphControl1.IsZoomOnMouseCenter := False;
  Self.ZedGraphControl1.Location := System.Drawing.Point.Create(8, 16);
  Self.ZedGraphControl1.Name := 'ZedGraphControl1';
  Self.ZedGraphControl1.PanButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.PanButtons2 := System.Windows.Forms.MouseButtons.Middle;
  Self.ZedGraphControl1.PanModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.PointDateFormat := 'g';
  Self.ZedGraphControl1.PointValueFormat := 'G';
  Self.ZedGraphControl1.ScrollMaxX := 0;
  Self.ZedGraphControl1.ScrollMaxY := 0;
  Self.ZedGraphControl1.ScrollMaxY2 := 0;
  Self.ZedGraphControl1.ScrollMinX := 0;
  Self.ZedGraphControl1.ScrollMinY := 0;
  Self.ZedGraphControl1.ScrollMinY2 := 0;
  Self.ZedGraphControl1.Size := System.Drawing.Size.Create(608, 296);
  Self.ZedGraphControl1.TabIndex := 0;
  Self.ZedGraphControl1.ZoomButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.ZoomButtons2 := System.Windows.Forms.MouseButtons.None;
  Self.ZedGraphControl1.ZoomModifierKeys := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomStepFraction := 0.100000001490116;
  // 
  // TFrmLinhas
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(632, 326);
  Self.Controls.Add(Self.ZedGraphControl1);
  Self.Name := 'TFrmLinhas';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'WinForm';
  Self.WindowState := System.Windows.Forms.FormWindowState.Maximized;
  Include(Self.Load, Self.TFrmLinhas_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrmLinhas.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrmLinhas.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TFrmLinhas.TFrmLinhas_Load(sender: System.Object; e: System.EventArgs);
var
  x, y1, y2: real;
  list1, list2: PointPairList;
  i: integer;
  myCurve, myCurve2: LineItem;

begin
  {Codigo obtido a partir do site http://www.codeproject.com/csharp/ZedGraph.asp,
  convertido de C# para Delphi por Manoel Campos }
  ZedGraphControl1.GraphPane.Title := 'My Test Graph'#13#10'(For CodeProject Sample)';
  ZedGraphControl1.GraphPane.XAxis.Title:= 'My X Axis';
  ZedGraphControl1.GraphPane.YAxis.Title:= 'My Y Axis';

  //Make up some data arrays based on the Sine function
  list1 := PointPairList.Create;
  list2 := PointPairList.Create;
  for i:=0 to 35 do
  begin
      x := i + 5;
      y1 := 1.5 + Math.Sin( i * 0.2 );
      y2 := 3.0 * ( 1.5 + Math.Sin( i * 0.2 ) );
      list1.Add( x, y1 );
      list2.Add( x, y2 );
  end;

  // Generate a red curve with diamond

  // symbols, and "Porsche" in the legend
  {myCurve := myPane.AddCurve( 'Porsche',
          list1, Color.Red, SymbolType.Diamond );}
   myCurve := ZedGraphControl1.GraphPane.AddCurve( 'Porsche',
          list1, Color.Red, SymbolType.Triangle );


  // Generate a blue curve with circle
  // symbols, and "Piper" in the legend
  {myCurve2 := myPane.AddCurve( 'Piper',
          list2, Color.Blue, SymbolType.Circle );}
  myCurve2 := ZedGraphControl1.GraphPane.AddCurve( 'Piper',
          list2, Color.Blue, SymbolType.Circle );


  // Tell ZedGraph to refigure the
  // axes since the data have changed
  //myPane.AxisChange( self.CreateGraphics() );
  ZedGraphControl1.GraphPane.AxisChange( self.CreateGraphics() );

  //efeitos
  // Change the color of the title
  ZedGraphControl1.GraphPane.FontSpec.FontColor := Color.Green;

  // Add gridlines to the plot, and make them gray
  ZedGraphControl1.GraphPane.XAxis.IsShowGrid := true;
  ZedGraphControl1.GraphPane.YAxis.IsShowGrid := true;
  ZedGraphControl1.GraphPane.XAxis.GridColor := Color.LightGray;
  ZedGraphControl1.GraphPane.YAxis.GridColor := Color.LightGray;

  // Move the legend location
  ZedGraphControl1.GraphPane.Legend.Position := ZedGraph.LegendPos.Bottom;

  // Make both curves thicker
  myCurve.Line.Width := 2.0;
  myCurve2.Line.Width := 2.0;

  // Fill the area under the curves
  myCurve.Line.Fill := Fill.Create( Color.White, Color.Red, 45 );
  myCurve2.Line.Fill := Fill.Create( Color.White, Color.Blue, 45 );

  // Increase the symbol sizes, and fill them with solid white
  myCurve.Symbol.Size := 8.0;
  myCurve2.Symbol.Size := 8.0;
  myCurve.Symbol.Fill := Fill.Create( Color.White );
  myCurve2.Symbol.Fill := Fill.Create( Color.White );

  // Add a background gradient fill to the axis frame
  ZedGraphControl1.GraphPane.AxisFill := Fill.Create( Color.White,
      Color.FromArgb( 255, 255, 210), -45 );
end;


end.
